// CtrlCard.cpp: implementation of the CCtrlCard class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "DEMO.h"
#include "CtrlCard.h"
#include "adt8840.h"


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

int devnum=-1;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CCtrlCard::CCtrlCard()
{
}
/******************* Initialization function, the function ************************ 
initialize the control card contains commonly used library functions, 
which is the basis for calling other functions, 
it must first call in the example program to 
return value <= 0 initialization failed, return value> 0 indicates a successful initialization

*****************************************************/
int CCtrlCard::Init_Board(int devnum)
{
	int idle,g_status,lock_stop;
/***********************************************************/

		if(devnum==0)
		{
			adt8840a_get_sys_status( devnum,&idle,&g_status,&lock_stop);
			if(idle==0 && g_status==0)
			{
				/*
				for (int i = 1; i<=MAXAXIS; i++)
				{
					adt8840a_set_command_pos(devnum, i,0);

					adt8840a_set_actual_pos(devnum, i,0);
				
					adt8840a_set_startv(devnum, i,0);
				
					adt8840a_set_speed(devnum, i,0);
				
					adt8840a_set_acc(devnum,i,0);

					adt8840a_clear_buff_depth(devnum);//ջ					
				}
				
			    adt8840a_stop_all (devnum );       //ֹͣ

				adt8840a_set_buff_mode(devnum, 1  ); //

				adt8840a_clear_buff_depth(devnum); //ջ
				
				adt8840a_set_speed_mode(devnum, 0 );  //ٶģʽ
				
				Uart_show (devnum, 0); //رմ
				*/
			}
				
			if(Result==0 )
				return 1;
			else 
				return Result;
		}
		else
			return -1;
}


/********************** Basis set speed module *********************** 
parameter to determine a set of uniform acceleration and deceleration, 
or the initial shaft speed, drive speed and acceleration 
parameters: axis - axis No. startv - initial speed 
speed - driving speed add - acceleration of the 
return value = 0 is correct, return value = 1 error
*********************************************************/
int CCtrlCard::Setup_Speed(int axis, long startv, long speed, long add )
{
	  
		if (startv - speed >= 0) //Uniform motion
		{
    
			Result = adt8840a_set_startv(devnum, axis, startv);
			
			adt8840a_set_speed (devnum, axis, startv);
		}
		else                    //Acceleration and deceleration motion
		{
    
			Result = adt8840a_set_startv(devnum, axis, startv);
			
			adt8840a_set_speed (devnum, axis, speed);
			
			adt8840a_set_acc (devnum, axis, add);
        
		}

	return Result;

}
/********************* Axis drive functions ********************** 
the function used to drive a single movement axis motion 
parameters: axis-axis number, value-output pulses 
return value = 0 is correct, return value = 1 error
*******************************************************/
int CCtrlCard::Axis_Pmove(int axis, long value)
{
	  	
	Result = adt8840a_pmove(devnum, axis, value);
	
	return Result;

}

/******************* Arbitrary two-axis interpolation function ******************** 
This function is used any two axes interpolation driving motion 
parameters: axis1, axis2-axis number, value1, value2-pulses 
return value = 0 is correct, return value = 1 error
*******************************************************/
int CCtrlCard::Interp_Move2(int axis1, int axis2, long value1, long value2)
{
	  	
	Result = adt8840a_inp_move2(devnum, axis1, axis2, value1, value2);

	return Result;

}
/******************* Arbitrary axis interpolation function, the function is used******************** 
arbitrary axes interpolation driving motion 
 parameters: axis1, axis2, axis3-axis number, 
 value1, value2, value3-pulses return value = 0 is correct, return value = 1 error
*******************************************************/
int CCtrlCard::Interp_Move3(int axis1, int axis2, int axis3, long value1, long value2, long value3)
{
	  
	Result = adt8840a_inp_move3(devnum, axis1, axis2, axis3, value1, value2, value3);

	return Result;

}

/******************* Four-axis interpolation function ************************* *** 
This function is used to drive XYZW four-axis interpolation of motion 
parameters were: value1, value2, value3, value4-output pulses 
return value = 0 is correct, return value = 1 error
***********************************************************/
int CCtrlCard::Interp_Move4(long value1, long value2, long value3, long value4)
{
	  	
	Result = adt8840a_inp_move4(devnum, value1, value2, value3, value4);

	return Result;

}

/************************ Stop shaft drive ********************** *
 This function is used to immediately stop or slow axis of the drive 
 parameter: axis-axis number, mode-reduction method (0 - stop, 1 - deceleration stop) 
 return value = 0 is correct, return value = 1 error
************************************************************/
int CCtrlCard::StopRun(int axis, int mode)
{
	  	
	if(mode == 0)       //Stop
    {
       Result = adt8840a_sudden_stop(devnum, axis);
	}   
    else                 //Deceleration stop
	{
        Result = adt8840a_dec_stop(devnum, axis);
	}   
    return Result;

}
/***************** Get the shaft-driven state ************************** 
function is used to obtain the axis of the drive state or interpolation driving status 
parameters: axis-axis number, 
value-status indicator (0 - drive end, non-0 - is driving) mode (0 - for single-axis drive status,
 1 - access interpolation drive state) return value = 0 is correct, 
 return value = 1 error
************************************************************/
int CCtrlCard::Get_Status(int axis, int &value, int mode)
{
	  	
	if (mode==0)          //Single-driven access to state
		
		Result=adt8840a_get_status(devnum,axis,&value);
	
	else                  //For interpolation driving status
		
		Result=adt8840a_get_inp_status(devnum,&value);
	
	return Result;

}

/***************** Access to sports information ***************************** * 
This function is used to feedback the logic of the current axis position, 
the actual position and speed parameters: axis-axis number, 
LogPos-logical position, ActPos-physical location, Speed-run rate of
 return value = 0 is correct, return value = 1 error
************************************************************/
int CCtrlCard::Get_CurrentInf(int axis, long &LogPos, long &ActPos, long &Speed )
{
	  	
		Result = adt8840a_get_command_pos(devnum,axis, &LogPos);
		
	    adt8840a_get_actual_pos (devnum, axis, &ActPos); 
		
	    adt8840a_get_speed (devnum, axis, &Speed);
		
		return Result;
	
}

/*********************** Read input ********************** ********* 
This function is used to read a single input 
parameter: number-input (0 to 39) return value: 0 - low, 1 - high, -1 - Error
****************************************************************/
int CCtrlCard::Read_Input(int number,int &value)
{	  

	Result = adt8840a_read_bit(devnum, number, &value); 
//	TRACE("%ld\n",Result);

	return Result;
}

/********************* Output single-point function ************************ ****** 
This function is used to output a single point of signal 
parameters: number-output point (0 ~ 15), value 0 - low, 1 - high return value = 0 is correct, return value = 1 error

****************************************************************/

int CCtrlCard::Write_Output(int number, int value)
{
	  
	Result = adt8840a_write_bit(devnum, number, value);

	return Result;

}
/******************* Set the location counter *************************** **** 
This function is used to set the logical location and actual location of the 
parameters: axis-axis number, pos-set position of the value of mode 
0 - set the logical location, non-0 - set the actual location of the 
return value = 0 is correct, return value = 1 error

****************************************************************/
	 
int CCtrlCard::Setup_Pos(int axis, long pos, int mode)
{
	  	
	if(mode==0)
	{
		Result = adt8840a_set_command_pos(devnum,axis, pos);
	}
	else
	{
		Result = adt8840a_set_actual_pos(devnum, axis, pos);
	}
	
	return Result;

}

/******************** Set the pulse output mode with the function ********************** 
work on the set pulse parameters: axis-axis number,
 value-pulse mode 0 - pulse + pulse mode 1 - Pulse + direction method 
 return value = 0 is correct, return value = 1 error default mode for
 the pulse + direction pulse mode of the program the default is the logic pulse and direction output signals are logic
*********************************************************/
int CCtrlCard::Setup_PulseMode(int axis, int value)
{
	  	
	Result = adt8840a_set_pulse_mode(devnum, axis, value, 0, 0);

	return Result;

}
/******************** Set limit signaling ********************** 
the function used to set the positive / negative direction limit input nLMT
 signal model parameters: axis-axis No. 
 value1 0 - is the effective limit 1 - Limit is invalid 
 value2 0 - negative limit effective 1 - negative limit 
 invalid logic 0 - active low 1 - high effective 
 default mode is: is the effective limit the negative limit, 
 active-low return value = 0 is correct, return value = 1 error
  *********************************************************/
int CCtrlCard::Setup_LimitMode(int axis, int value1, int value2, int logic)
{
	Result = adt8840a_set_limit_mode(devnum, axis, value1, value2, logic);

	return Result;

}
/******************** Set stop0 signaling ********************** 
use the function to set the parameters of the model 
signal stop0: axis-axis number value 0 - invalid 1 - effective 
logic 0 - active low 1 - high effective default mode: Invalid
 return value = 0 is correct, return value = 1 error
  *********************************************************/
int CCtrlCard::Setup_Stop0Mode(int axis, int value, int logic)
{	  

	Result = adt8840a_set_stop0_mode(devnum, axis, value ,logic);

	return Result;

}
/******************** Set stop1 signaling ********************** 
use the function to set the parameters of the model 
signal stop1: axis-axis number value 0 - invalid 1 - effective 
logic 0 - active low 1 - high effective default mode: Invalid 
return value = 0 is correct, return value = 1 error
  *********************************************************/
int CCtrlCard::Setup_Stop1Mode(int axis, int value, int logic)
{	  

	Result = adt8840a_set_stop1_mode(devnum, axis, value, logic);

	return Result;

}


/************************ Uniaxial continuous drive function ******************** ***
 This function is used to drive a single movement axis motion 
 parameters: axis-axis number, value-pulse direction of the correct 
 return value = 0, return value = 1 error
***********************************************************/
int CCtrlCard::Axis_Cmove(int axis, long value)
{
	Result = adt8840a_continue_move(devnum,axis, value);
	return Result;	
}

/***************** Access to all axis motion information *************************** *** 
This function is used to feedback the logic axis current position of all axes,
the actual position and speed parameters: axis-axis number,
 LogPos-logical position, ActPos-physical location, Speed-run rate of 
 return value = 0 is correct, the return value = 1 Error
 description: The Get_CurrentInf () for each axis by axis No. different information,
 this function can be a complete 4-axis access to information
************************************************************/
int CCtrlCard::Get_AxisInfo(int dev_num, long LogPos[], long ActPos[], long Speed[])
{
	Result =adt8840a_all_command_pos(devnum,LogPos);
	adt8840a_all_actual_pos(devnum,ActPos);
	adt8840a_all_speed(devnum,Speed);
    return Result;	
}
